package furny.ga.logger.entities;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * Database entry for an evaluation run.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
@Entity
@Cache(usage = CacheConcurrencyStrategy.READ_ONLY)
public class EvaluationRunEntry {

  /** The id. */
  private long id;

  /** The started date. */
  private Date started;

  /** The ended date. */
  private Date ended;

  /**
   * Instantiates a new evaluation run entry.
   */
  public EvaluationRunEntry() {
  }

  /**
   * Gets the id.
   * 
   * @return the id
   */
  @Id
  @GeneratedValue
  public long getId() {
    return id;
  }

  /**
   * Sets the id.
   * 
   * @param id
   *          the new id
   */
  private void setId(final long id) {
    this.id = id;
  }

  /**
   * Gets the started date.
   * 
   * @return the started date
   */
  public Date getStarted() {
    return started;
  }

  /**
   * Sets the started date.
   * 
   * @param started
   *          the new started date
   */
  public void setStarted(final Date started) {
    this.started = started;
  }

  /**
   * Gets the ended date.
   * 
   * @return the ended date
   */
  public Date getEnded() {
    return ended;
  }

  /**
   * Sets the ended date.
   * 
   * @param ended
   *          the new ended date
   */
  public void setEnded(final Date ended) {
    this.ended = ended;
  }

}
